/**
 * @class TitleBar
 * @singleton
 * @author: <a href="mailto:simonsliu@tencent.com">simonsliu</a>
 */
(function() {
	var
		/**
		 * @private
		 * @property {Object} data
		 * 控件数据
 		 */
		data = {},
		/**
		 * @private
		 * @property {String} tmpl
		 * 控件模版
		 */
		tmpl = [
			'<div class="text">',
			'${title}',
			' - QQ浏览器 ',
			'${nickname}',
			'${uin}',
			'</div>'
		].join(''),
		/**
		 * @private
		 * @property {RegExp} rTmplVariable
		 * 模版变量匹配正则表达式
		 */
		rTmplVariable = /(\${)(\w+)(})/g;

	Cube.define('Skin.app.TitleBar', {
		config: {
			element: null,
			onIconContDblClick: null
		},
		/**
		 * @param {Cube.Element} elem
		 */
		constructor: function(config) {
			this.$initConfig(config);

			this.contentCont = Cube('<div>')
				.addClass('content')
				.appendTo(this.element);

			// 初始化数据
			this.setData({
				title: '',
				nickname: '',
				uin: ''
			});
		},
		/**
		 * 设置数据
		 * @param {Object} o 数据对象
		 */
		setData: function(o) {
			var html;

			Cube.extend(true, data, o);

			html = tmpl.replace(rTmplVariable, function(match, prefix, name, postfix) {
				// 帐号信息两侧需加括号
				return name === 'uin'
					? (data[name] ? '(' + data[name] + ')' : '')
					: data[name]
			});

			this.contentCont.html(html);
		}
	});
})();